/*
 * Decompiled with CFR 0.152.
 */
package troy.generic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoBackupFunctions {
    private final int EXTLEN = 5;
    private final String EXTPREFIX = "autobak";
    private final String EXTOLDSUFFIX = "old";

    private String padZero(String string, int n) {
        for (int i = 0; i < n && string.length() < n; ++i) {
            string = "0" + string;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[4096];
            while ((n = fileInputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    private ArrayList<File> findExistingBackups(File file, String string) {
        String[] stringArray;
        ArrayList<File> arrayList = new ArrayList<File>();
        final String string2 = string;
        for (String string3 : stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.matches(string2.replace(".", "\\.") + "\\." + "autobak" + "[0-9]{" + 5 + "}");
            }
        })) {
            System.out.print("\t" + string3 + " ... ");
            System.out.print("MATCH!");
            arrayList.add(new File(file, string3));
            System.out.println();
        }
        return arrayList;
    }

    public int createBackup(String string, int n) {
        File file = new File(string);
        ArrayList<File> arrayList = null;
        ArrayList<File> arrayList2 = new ArrayList<File>();
        boolean bl = false;
        if (!file.exists()) {
            System.out.println("Original file does not exist.");
            return -1;
        }
        String string2 = file.getName();
        System.out.println("Dir contents:");
        arrayList = this.findExistingBackups(file.getParentFile(), string2);
        Collections.sort(arrayList, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return -1 * file.getName().compareTo(file2.getName());
            }
        });
        int n2 = 0;
        System.out.println("Sorted:");
        for (File object2 : arrayList) {
            System.out.print("\t" + object2.getAbsolutePath());
            if (++n2 > n - 1) {
                System.out.print(" (DEL");
                if (!object2.canWrite()) {
                    System.out.print(" - NO WRITE ACCESSS");
                } else if (!object2.delete()) {
                    System.out.print(" - FAILED");
                }
                System.out.print("!)");
            } else {
                arrayList2.add(object2);
            }
            System.out.println();
        }
        arrayList = arrayList2;
        System.out.println("After Cleansing:");
        for (File file2 : arrayList) {
            System.out.println("\t" + file2.getName());
        }
        Object object = file.getAbsolutePath();
        if (arrayList.size() == 0) {
            object = (String)object + ".autobak" + this.padZero("0", 5);
        } else {
            String string3 = arrayList.get(0).getName();
            int n3 = Integer.parseInt(string3.substring(string3.length() - 5)) + 1;
            if (Integer.toString(n3).length() > 5) {
                System.out.println("*** OVERFLOW! ALERT USER! IMPORTANT! ***");
                bl = true;
                object = (String)object + ".autobak" + this.padZero("0", 5);
                for (File file3 : arrayList) {
                    System.out.println("Renamed " + file3.getName() + " to " + file3.getName() + "." + "old" + " !");
                    file3.renameTo(new File(file3.getAbsolutePath() + "." + "old"));
                }
            } else {
                object = (String)object + ".autobak" + this.padZero(Integer.toString(n3), 5);
            }
        }
        try {
            this.copy(file, new File((String)object));
            System.out.println("\nNew Backup: " + (String)object);
            return bl ? 1 : 0;
        }
        catch (IOException iOException) {
            System.out.println("\nERROR: " + iOException.getMessage() + "\n");
            iOException.printStackTrace();
            return -2;
        }
    }
}

