/*
 * Decompiled with CFR 0.152.
 */
package troy.generic;

import artofillusion.ApplicationPreferences;
import artofillusion.ModellingApp;
import artofillusion.Plugin;
import artofillusion.SafeFileOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TroySettings
implements Plugin {
    private static final File SETTINGSFILE;
    private static Hashtable<String, Hashtable<String, String>> set;

    private static void dumpSet() {
        String string = "START\n";
        Enumeration<String> enumeration = set.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            Hashtable<String, String> hashtable = set.get(string2);
            string = string + "Section: |" + string2 + "|\n";
            Enumeration<String> enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                String string3 = enumeration2.nextElement();
                String string4 = hashtable.get(string3);
                string = string + "\t|" + string3 + "| = |" + string4 + "|\n";
            }
        }
        string = string + "EOF";
        System.out.println(string);
    }

    public static void set(String string, String string2, String string3) {
        if (set.get(string) == null) {
            set.put(string, new Hashtable());
        }
        set.get(string).put(string2, string3);
    }

    public static String get(String string, String string2) {
        Hashtable<String, String> hashtable = set.get(string);
        if (hashtable == null) {
            return "";
        }
        String string3 = hashtable.get(string2);
        if (string3 == null) {
            return "";
        }
        return string3;
    }

    public static void load() {
        try {
            File file = SETTINGSFILE;
            if (file.exists()) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                TroySettings.readFromXML(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
            } else {
                System.out.println("TroySettings: " + SETTINGSFILE + " does not exist, loading default values.");
                TroySettings.set("startup", "boxMaximize", "1");
                TroySettings.set("startup", "boxShow", "1");
                TroySettings.set("startup", "boxSnap", "1");
                TroySettings.set("startup", "boxAmbient", "1");
                TroySettings.set("startup", "boxLight", "1");
                TroySettings.set("startup", "boxCam", "1");
                TroySettings.set("autobackup", "boxActive", "0");
                TroySettings.set("autobackup", "textLevels", "10");
            }
        }
        catch (Exception exception) {
            System.out.print("TroySettings: " + SETTINGSFILE + " could not be read, StackTrace:\n\n");
            exception.printStackTrace();
        }
    }

    private static void readFromXML(InputStream inputStream) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        NodeList nodeList = document.getFirstChild().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.hasChildNodes()) continue;
            String string = node.getNodeName();
            set.put(string, new Hashtable());
            Hashtable<String, String> hashtable = set.get(string);
            NodeList nodeList2 = node.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node2 = nodeList2.item(j);
                if (!node2.hasAttributes()) continue;
                String string2 = node2.getNodeName();
                String string3 = node2.getAttributes().getNamedItem("value").getNodeValue();
                hashtable.put(string2, string3);
            }
        }
    }

    public static void save() {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            File file = SETTINGSFILE;
            System.out.println("TroySettings: Saving settings to " + file.getAbsolutePath());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("settings");
            document.appendChild(element);
            Enumeration<String> enumeration = set.keys();
            while (enumeration.hasMoreElements()) {
                object5 = enumeration.nextElement();
                object4 = set.get(object5);
                object3 = document.createElement((String)object5);
                element.appendChild((Node)object3);
                object2 = ((Hashtable)object4).keys();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    String string = (String)((Hashtable)object4).get(object);
                    Element element2 = document.createElement((String)object);
                    element2.setAttribute("value", string);
                    object3.appendChild(element2);
                }
            }
            object5 = new BufferedOutputStream((OutputStream)new SafeFileOutputStream(file, 0));
            object4 = new DOMSource(document);
            object3 = new StreamResult((OutputStream)object5);
            object2 = TransformerFactory.newInstance();
            object = ((TransformerFactory)object2).newTransformer();
            ((Transformer)object).setOutputProperty("indent", "yes");
            ((Transformer)object).transform((Source)object4, (Result)object3);
            ((OutputStream)object5).close();
            System.out.println("TroySettings: Saving ok.");
        }
        catch (Exception exception) {
            System.out.println("TroySettings: Exception while saving, StackTrace:\n\n");
            exception.printStackTrace();
        }
    }

    public void processMessage(int n, Object[] objectArray) {
        if (n == 0) {
            TroySettings.load();
        } else if (n == 1) {
            TroySettings.save();
        }
    }

    static {
        ModellingApp.getPreferences();
        SETTINGSFILE = new File(ApplicationPreferences.getPreferencesDirectory(), "TroyTools.xml");
        set = new Hashtable();
    }
}

