/*
 * Decompiled with CFR 0.152.
 */
package troy.generic;

import artofillusion.LayoutWindow;
import artofillusion.ModellingTool;
import artofillusion.Plugin;
import artofillusion.Scene;
import artofillusion.ViewerCanvas;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import troy.generic.StartupHelperDlg;
import troy.generic.TroySettings;

public class StartupHelper
implements Plugin,
ModellingTool {
    public String getName() {
        return "TT: StartupHelper...";
    }

    public void commandSelected(LayoutWindow layoutWindow) {
        new StartupHelperDlg(layoutWindow);
    }

    private void doAutoGrid(LayoutWindow layoutWindow) {
        Scene scene = layoutWindow.getScene();
        if (TroySettings.get("startup", "boxShow").equals("1")) {
            if (!scene.getShowGrid()) {
                System.out.println("TroyTools/StartupHelper, AutoGrid: setShowGrid(true)");
                scene.setShowGrid(true);
            } else {
                System.out.println("TroyTools/StartupHelper, AutoGrid: Scene already has grid enabled");
            }
        }
        if (TroySettings.get("startup", "boxSnap").equals("1")) {
            if (!scene.getSnapToGrid()) {
                scene.setSnapToGrid(true);
                System.out.println("TroyTools/StartupHelper, AutoGrid: setSnapToGrid(true)");
            } else {
                System.out.println("TroyTools/StartupHelper, AutoGrid: Scene already has snap-to-grid enabled");
            }
        }
        for (ViewerCanvas viewerCanvas : layoutWindow.getAllViews()) {
            double d = viewerCanvas.getGridSpacing();
            int n = viewerCanvas.getSnapToSubdivisions();
            viewerCanvas.setGrid(d, n, TroySettings.get("startup", "boxShow").equals("1"), TroySettings.get("startup", "boxSnap").equals("1"));
            System.out.println("TroyTools/StartupHelper, AutoGrid: ViewCanvas updated: " + viewerCanvas);
        }
    }

    private void doMaximize(LayoutWindow layoutWindow) {
        if (TroySettings.get("startup", "boxMaximize").equals("1")) {
            layoutWindow.getFrame().setMaximized(true);
            System.out.println("TroyTools/StartupHelper, Scene Window maximized");
        }
    }

    private void doResetAmbient(LayoutWindow layoutWindow) {
        Scene scene = layoutWindow.getScene();
        if (TroySettings.get("startup", "boxAmbient").equals("1") && scene.getName() == null) {
            scene.setAmbientColor(new RGBColor(0.0, 0.0, 0.0));
            System.out.println("TroyTools/StartupHelper, Ambient color set to black");
        }
    }

    private void doKillLight(LayoutWindow layoutWindow) {
        Scene scene = layoutWindow.getScene();
        if (TroySettings.get("startup", "boxLight").equals("1") && scene.getName() == null) {
            ObjectInfo objectInfo = null;
            int n = scene.getNumObjects();
            for (int i = 0; i < n; ++i) {
                objectInfo = scene.getObject(i);
                if (objectInfo == null || !objectInfo.name.equals("Light 1")) continue;
                scene.removeObject(i, null);
                layoutWindow.rebuildItemList();
                System.out.println("TroyTools/StartupHelper, Directional light killed");
                return;
            }
        }
    }

    private void doAlterCam(LayoutWindow layoutWindow) {
        Scene scene = layoutWindow.getScene();
        if (TroySettings.get("startup", "boxCam").equals("1") && scene.getName() == null) {
            ObjectInfo objectInfo = null;
            int n = scene.getNumObjects();
            for (int i = 0; i < n; ++i) {
                objectInfo = scene.getObject(i);
                if (objectInfo == null || !objectInfo.name.equals("Camera 1") || !(objectInfo.object instanceof SceneCamera)) continue;
                objectInfo.coords.setOrigin(new Vec3(-11.0, 9.0, 15.0));
                objectInfo.coords.setOrientation(-25.0, -145.0, 5.0);
                scene.objectModified(objectInfo.object);
                objectInfo.object.sceneChanged(objectInfo, scene);
                layoutWindow.updateImage();
                System.out.println("TroyTools/StartupHelper, SceneCamera adjusted");
                return;
            }
        }
    }

    public void processMessage(int n, Object[] objectArray) {
        if (n == 2) {
            System.out.println("TroyTools/StartupHelper, caught msg: SCENE_WINDOW_CREATED");
            LayoutWindow layoutWindow = (LayoutWindow)objectArray[0];
            this.doAutoGrid(layoutWindow);
            this.doMaximize(layoutWindow);
            this.doResetAmbient(layoutWindow);
            this.doKillLight(layoutWindow);
            this.doAlterCam(layoutWindow);
        }
    }
}

