/*
	Options dialog for AutoBackup
	separated from AutoBackup to keep memory req's low

	.dm'TroY., October 2007
 */ 

package troy.generic;

import artofillusion.LayoutWindow;
import artofillusion.ui.UIUtilities;
import artofillusion.ModellingApp;
import buoy.event.CommandEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.ColumnContainer;
import buoy.widget.GridContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.BDialog;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BTextField;
import buoy.widget.BLabel;
import buoy.widget.BorderContainer;
import javax.swing.BorderFactory;
import java.awt.Insets;

/**
 * Options dialog for AutoBackup
 */
public class AutoBackupDlg extends BDialog
{
	private BCheckBox boxActive   = new BCheckBox("AutoBackup activated", false);
	private BTextField textLevels = new BTextField();
	
	private BButton bOK = new BButton("Save");
	private BButton bCancel = new BButton("Cancel");

	/**
	 * This constructor is called by StartupHelper.commandSelected(...) (user clicks on menu entry)
	 */
	public AutoBackupDlg(LayoutWindow parent)
	{
		super(parent, "AutoBackup - Options", true); // modal
		
		LayoutInfo grow       = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.HORIZONTAL, null, null);
		LayoutInfo growInsets = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(10, 10, 10, 10), null);
		LayoutInfo growCenter = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, null, null);
		
		// where everything sits in
		ColumnContainer main  = new ColumnContainer();
		// gc for the text-field and label
		GridContainer texts   = new GridContainer(2, 1);
		// gc for the two buttons
		GridContainer buttons = new GridContainer(2, 1);
		
		// add checkbox directly to cc
		main.add(boxActive, growInsets);

		// label and textfield go into first gc
		texts.add(new BLabel("Number of old backups:"), 0, 0, growInsets);
		texts.add(textLevels, 1, 0, growInsets);
		
		main.add(texts, growCenter);
		
		// the two buttons go into our second gc
		buttons.add(bOK, 0, 0, growInsets);
		buttons.add(bCancel, 1, 0, growInsets);
		
		main.add(buttons, growCenter);
		
		// read settings and set controls accordingly
		boxActive.setState(TroySettings.get("autobackup", "boxActive").equals("1") ? true : false);
		textLevels.setText(TroySettings.get("autobackup", "textLevels"));
		
		// add some events ..
		bOK.addEventLink(CommandEvent.class, this, "clickOK");
		bCancel.addEventLink(CommandEvent.class, this, "clickCancel");
		
		addEventLink(WindowClosingEvent.class, this, "clickCancel");
		
		this.setContent(main);
		this.pack();

		UIUtilities.centerDialog(this, parent);
		
		this.setResizable(false);
		this.setVisible(true);
	}
	
	/**
	 * click on cancel button, also called by WindowClosingEvent. dismiss everything.
	 */
	private void clickCancel()
	{
		dispose();
	}
	
	/**
	 * click on ok button: save settings (to TroySettings and .XML) and get lost
	 */
	private void clickOK()
	{
		TroySettings.set("autobackup", "boxActive", (boxActive.getState() ? "1" : "0"));
		TroySettings.set("autobackup", "textLevels", textLevels.getText());
	
		TroySettings.save();
	
		dispose();
	}
}
