/*
	This is some kind of startup manager. I wasn't very happy
	with some things behaviour, so I wrote this little plugin
	to enhance customizability.

	.dm'TroY., October 2007


	Some notes (mostly to myself):
	- Plugin MUST be implemented for the plugin to work. 
	  It's method processMessage() only handles SCENE_WINDOW_CREATED here.
	- ModellingTool is implemented in order to get a menu entry.
 */


package troy.generic;

import artofillusion.Plugin;
import artofillusion.ModellingTool;
import artofillusion.LayoutWindow;
import artofillusion.ViewerCanvas;
import artofillusion.Scene;
import artofillusion.math.Vec3;
import artofillusion.math.RGBColor;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;

/**
 * Applies all changes to AoIs behaviour during creation of new LayoutWindows
 */
public class StartupHelper implements Plugin, ModellingTool
{
	/**
	 * for ModellingTool: name of entry in the menu
	 */
	public String getName()
	{
		return "TT: StartupHelper...";
	}
	/**
	 * for ModellingTool: what happens when menu item is clicked
	 */
	public void commandSelected(LayoutWindow lw)
	{
		new StartupHelperDlg(lw);
	}

	/**
	 * activates grid and snap-to-grid if desired
	 */
	private void doAutoGrid(LayoutWindow lw)
	{
		// #########################################################################
		// ### AutoGrid
		
		Scene sc = lw.getScene();
		
		if (TroySettings.get("startup", "boxShow").equals("1"))
		{		
			// alter the scene directly
			if (!(sc.getShowGrid()))
			{
				System.out.println("TroyTools/StartupHelper, AutoGrid: setShowGrid(true)");
				sc.setShowGrid(true);
			}
			else
			{
				System.out.println("TroyTools/StartupHelper, AutoGrid: Scene already has grid enabled");
			}
		
		}
		
		if (TroySettings.get("startup", "boxSnap").equals("1"))		
		{
			if (!(sc.getSnapToGrid()))
			{
				sc.setSnapToGrid(true);
				System.out.println("TroyTools/StartupHelper, AutoGrid: setSnapToGrid(true)");
			}
			else
			{
				System.out.println("TroyTools/StartupHelper, AutoGrid: Scene already has snap-to-grid enabled");
			}
		}

		// as a look at LayoutWindow.java revealed: all viewports need to be adjusted, too.
		// so, iterate through the window's views
		for (ViewerCanvas v : lw.getAllViews())
		{
			// we call this:
			//     public void setGrid(double spacing, int subdivisions, boolean show, boolean snap)
			// we'll set the last two booleans, so what we need are the first two values ...
			
			double sp = v.getGridSpacing();
			int   sub = v.getSnapToSubdivisions();
			
			// now we can set the grid's parameters
			v.setGrid(sp, sub,
						(TroySettings.get("startup", "boxShow").equals("1") ? true : false),
						(TroySettings.get("startup", "boxSnap").equals("1") ? true : false));
			
			// log again
			System.out.println("TroyTools/StartupHelper, AutoGrid: ViewCanvas updated: " + v);
		}
	}
	
	/**
	 * maximizes window if desired
	 */
	private void doMaximize(LayoutWindow lw)
	{
		// #########################################################################
		// ### Maximize Window
		if (TroySettings.get("startup", "boxMaximize").equals("1"))
		{
			lw.getFrame().setMaximized(true);	
		
			System.out.println("TroyTools/StartupHelper, Scene Window maximized");
		}
	}
	
	/**
	 * resets ambient light to black if desired - only new scenes
	 */
	private void doResetAmbient(LayoutWindow lw)
	{
		// #########################################################################
		// ### Set ambient color to pure black
		
		Scene sc = lw.getScene();
		
		if (TroySettings.get("startup", "boxAmbient").equals("1")
			&& sc.getName() == null)
		{
			sc.setAmbientColor(new RGBColor(0.0, 0.0, 0.0));
		
			System.out.println("TroyTools/StartupHelper, Ambient color set to black");
		}
	}
	
	/**
	 * kills the initial directional light if desired - only new scenes
	 */
	private void doKillLight(LayoutWindow lw)
	{
		// #########################################################################
		// ### Kill initial directional light
		
		Scene sc = lw.getScene();
		
		if (TroySettings.get("startup", "boxLight").equals("1")
			&& sc.getName() == null)
		{
			ObjectInfo oi  = null;
			int        num = sc.getNumObjects();
			
			for (int i = 0; i < num; i++)
			{
				oi = sc.getObject(i);
				if (oi != null && oi.name.equals("Light 1"))
				{
					sc.removeObject(i, null);
					
					lw.rebuildItemList();
			
					System.out.println("TroyTools/StartupHelper, Directional light killed");

					return;
				}
			}
		}
	}
	
	/**
	 * alters the scenes camera if desired - only new scenes
	 */
	private void doAlterCam(LayoutWindow lw)
	{
		// #########################################################################
		// ### Alter camera
		
		Scene sc = lw.getScene();
		
		if (TroySettings.get("startup", "boxCam").equals("1")
			&& sc.getName() == null)
		{
			ObjectInfo oi  = null;
			int        num = sc.getNumObjects();
			
			for (int i = 0; i < num; i++)
			{
				oi = sc.getObject(i);
				if (oi != null && oi.name.equals("Camera 1") && oi.object instanceof SceneCamera)
				{
					oi.coords.setOrigin(new Vec3(-11.0, 9.0, 15.0));
					oi.coords.setOrientation(-25.0, -145.0, 5.0);
					
					sc.objectModified(oi.object);
					oi.object.sceneChanged(oi, sc);
					
					lw.updateImage();
			
					System.out.println("TroyTools/StartupHelper, SceneCamera adjusted");

					return;
				}
			}
		}
	}

	/**
	 * process AoI messages: apply all changes
	 */
	public void processMessage(int message, java.lang.Object[] args)
	{
		if (message == SCENE_WINDOW_CREATED)
		{
			// something for the log ...
			System.out.println("TroyTools/StartupHelper, caught msg: SCENE_WINDOW_CREATED");
			
			// get the newly created window
			LayoutWindow lw = (LayoutWindow)args[0];
			
			// do our auto-stuff
			doAutoGrid(lw);
			doMaximize(lw);
			doResetAmbient(lw);
			doKillLight(lw);
			doAlterCam(lw);
		}
	}
}
