/*
	Options dialog for StartupHelper
	separated from StartupHelper to keep memory req's low

	.dm'TroY., October 2007
 */ 

package troy.generic;

import artofillusion.LayoutWindow;
import artofillusion.ui.UIUtilities;
import artofillusion.ModellingApp;
import buoy.event.CommandEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.ColumnContainer;
import buoy.widget.GridContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.BDialog;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BOutline;
import buoy.widget.BorderContainer;
import javax.swing.BorderFactory;
import java.awt.Insets;

/**
 * Options dialog for StartupHelper
 */
public class StartupHelperDlg extends BDialog
{
	private ColumnContainer cc       = new ColumnContainer();
	private ColumnContainer ccFirst  = new ColumnContainer();
	private ColumnContainer ccSecond = new ColumnContainer();
	private GridContainer   gc       = new GridContainer(2, 1);
	
	private BCheckBox boxMaximize = new BCheckBox("Maximize window", false);
	private BCheckBox boxShow     = new BCheckBox("Activate \"Show Grid\"", false);
	private BCheckBox boxSnap     = new BCheckBox("Activate \"Snap-to-Grid\"", false);
	
	private BCheckBox boxAmbient  = new BCheckBox("Reset ambient color to black", false);
	private BCheckBox boxLight    = new BCheckBox("Kill initial directional light", false);
	private BCheckBox boxCam      = new BCheckBox("Alter camera for better view", false);
	
	private BButton bOK = new BButton("Save");
	private BButton bCancel = new BButton("Cancel");

	/**
	 * This constructor is called by StartupHelper.commandSelected(...) (user clicks on menu entry)
	 */
	public StartupHelperDlg(LayoutWindow parent)
	{
		super(parent, "StartupHelper - Options", true); // modal
		
		LayoutInfo grow       = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.HORIZONTAL, null, null);
		LayoutInfo growInsets = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(10, 10, 10, 10), null);
		LayoutInfo growCenter = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, null, null);
		
		
		
		ccFirst.add(boxMaximize, grow);
		ccFirst.add(boxShow, grow);
		ccFirst.add(boxSnap, grow);
		
		BorderContainer bcFirst = new BorderContainer();
		bcFirst.setDefaultLayout(growInsets);
		bcFirst.add(new BOutline(ccFirst, BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "New or opened scenes")), BorderContainer.CENTER);

		cc.add(bcFirst, growCenter);
		
		
		
		ccSecond.add(boxAmbient, grow);
		ccSecond.add(boxLight, grow);
		ccSecond.add(boxCam, grow);
		
		BorderContainer bcSecond = new BorderContainer();
		bcSecond.setDefaultLayout(growInsets);
		bcSecond.add(new BOutline(ccSecond, BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Only new scenes")), BorderContainer.CENTER);
		
		cc.add(bcSecond, growCenter);
		
		
		boxMaximize.setState(TroySettings.get("startup", "boxMaximize").equals("1") ? true : false);
		boxShow.setState(TroySettings.get("startup", "boxShow").equals("1") ? true : false);
		boxSnap.setState(TroySettings.get("startup", "boxSnap").equals("1") ? true : false);
		boxAmbient.setState(TroySettings.get("startup", "boxAmbient").equals("1") ? true : false);
		boxLight.setState(TroySettings.get("startup", "boxLight").equals("1") ? true : false);
		boxCam.setState(TroySettings.get("startup", "boxCam").equals("1") ? true : false);
		
		
		gc.add(bOK, 0, 0, growInsets);
		gc.add(bCancel, 1, 0, growInsets);
		
		cc.add(gc, growCenter);
		
		bOK.addEventLink(CommandEvent.class, this, "clickOK");
		bCancel.addEventLink(CommandEvent.class, this, "clickCancel");
		
		addEventLink(WindowClosingEvent.class, this, "clickCancel");
		
		this.setContent(cc);
		this.pack();

		UIUtilities.centerDialog(this, parent);
		
		this.setResizable(false);
		this.setVisible(true);
	}
	
	/**
	 * click on cancel button, also called by WindowClosingEvent. dismiss everything.
	 */
	private void clickCancel()
	{
		dispose();
	}
	
	/**
	 * click on ok button: save settings (to TroySettings and .XML) and get lost
	 */
	private void clickOK()
	{
		TroySettings.set("startup", "boxMaximize", (boxMaximize.getState() ? "1" : "0"));
		TroySettings.set("startup", "boxShow", (boxShow.getState() ? "1" : "0"));
		TroySettings.set("startup", "boxSnap", (boxSnap.getState() ? "1" : "0"));
		TroySettings.set("startup", "boxAmbient", (boxAmbient.getState() ? "1" : "0"));
		TroySettings.set("startup", "boxLight", (boxLight.getState() ? "1" : "0"));
		TroySettings.set("startup", "boxCam", (boxCam.getState() ? "1" : "0"));
	
		TroySettings.save();
	
		dispose();
	}
}
