/*
	Automatically creates backups when saving a scene

	.dm'TroY., October 2007
 */


package troy.generic;

import artofillusion.Plugin;
import artofillusion.ModellingTool;
import artofillusion.LayoutWindow;
import java.io.File;
import buoy.widget.BStandardDialog;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.IOException;

/**
 * Applies all changes to AoIs behaviour during creation of new LayoutWindows
 */
public class AutoBackup implements Plugin, ModellingTool
{
	/**
	 * for ModellingTool: name of entry in the menu
	 */
	public String getName()
	{
		return "TT: AutoBackup...";
	}
	/**
	 * for ModellingTool: what happens when menu item is clicked
	 */
	public void commandSelected(LayoutWindow lw)
	{
		new AutoBackupDlg(lw);
	}

	/**
	 * process AoI messages: catch scene saved msg
	 */
	public void processMessage(int message, java.lang.Object[] args)
	{
		if (message == SCENE_SAVED && TroySettings.get("autobackup", "boxActive").equals("1"))
		{
			/*
			try
			{
				FileWriter outstream = new FileWriter(new File("C:\\omg.txt"));
				PrintWriter output = new PrintWriter(outstream);
				output.println("-- TICK --");
				output.close();
			}
			catch (Exception e)
			{}
			*/
			
			// something for the log ...
			System.out.println("TroyTools/AutoBackup, caught msg: SCENE_SAVED");

			// scene has been saved to:
			if (args[0] instanceof File && args[1] instanceof LayoutWindow)
			{
				String origFilename = ((File)args[0]).getAbsolutePath();
				
				AutoBackupFunctions a = new AutoBackupFunctions();
				int maxLevels = Integer.parseInt(TroySettings.get("autobackup", "textLevels"));
				int ret = a.createBackup(origFilename, maxLevels);
				if (ret == 1)
				{
					// OVERFLOW!
					new BStandardDialog
						(
							"AutoBackup",
							"WARNING:\n\nYou have produced more AutoBackups than this plugin can handle! Please check your backups for this scene.\n\nA new backup-round has been started, but this plugin can't handle a second overflow!",
							BStandardDialog.WARNING
						).showMessageDialog((LayoutWindow)args[1]);
				}
				else if (ret < 0)
				{
					// Other error
					new BStandardDialog
						(
							"AutoBackup",
							"An error occured while creating an AutoBackup file. See logfile for details.",
							BStandardDialog.ERROR
						).showMessageDialog((LayoutWindow)args[1]);
				}
			}
		}
	}
}
