/*
 * Decompiled with CFR 0.152.
 */
package troy.advcurves;

import artofillusion.CurveViewer;
import artofillusion.WireframeMesh;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.ui.MeshEditController;
import buoy.event.WidgetMouseEvent;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Color;
import troy.advcurves.AdvCurveEditorWindow;
import troy.advcurves.MathHelper;

public class AdvCurveViewer
extends CurveViewer {
    private boolean mouseMoved = false;

    public AdvCurveViewer(MeshEditController window, RowContainer p) {
        super(window, p);
    }

    protected void drawObject() {
        this.drawSmoothed(lineColor);
        this.drawOutline(disabledColor);
        this.drawHandles(lineColor, specialHighlightColor);
        this.drawArrow(lineColor);
    }

    protected void drawHandles(Color commonHandle, Color startEndHandle) {
        if (!this.showMesh) {
            return;
        }
        MeshVertex[] v = ((Mesh)this.getController().getObject().getObject()).getVertices();
        boolean[] selected = this.controller.getSelection();
        Color col = null;
        for (int i = 0; i < v.length; ++i) {
            if (!(this.theCamera.getObjectToView().timesZ(v[i].r) > this.theCamera.getClipDistance())) continue;
            col = i == 0 || i == v.length - 1 ? startEndHandle : commonHandle;
            if (selected[i]) {
                col = highlightColor;
            }
            Vec2 p = this.theCamera.getObjectToScreen().timesXY(v[i].r);
            double z = this.theCamera.getObjectToView().timesZ(v[i].r);
            this.renderBox((int)p.x - 2, (int)p.y - 2, 5, 5, z, col);
        }
    }

    protected void drawSmoothed(Color curveColor) {
        WireframeMesh wireframe = null;
        Object3D theObject = this.getController().getObject().getObject();
        if (theObject instanceof Curve) {
            Curve theCurve = (Curve)theObject;
            wireframe = theCurve.getSmoothingMethod() != 0 ? theCurve.subdivideCurve().getWireframeMesh() : theCurve.getWireframeMesh();
            for (int i = 0; i < wireframe.from.length; ++i) {
                this.renderLine(wireframe.vert[wireframe.from[i]], wireframe.vert[wireframe.to[i]], this.theCamera, curveColor);
            }
        }
    }

    protected void drawOutline(Color outlineColor) {
        Curve theCurve;
        int smBefore;
        if (!this.showMesh) {
            return;
        }
        WireframeMesh wireframe = null;
        Object3D theObject = this.getController().getObject().getObject();
        if (theObject instanceof Curve && (smBefore = (theCurve = (Curve)theObject).getSmoothingMethod()) != 0) {
            theCurve.setSmoothingMethod(0);
            wireframe = theCurve.getWireframeMesh();
            for (int i = 0; i < wireframe.from.length; ++i) {
                this.renderLine(wireframe.vert[wireframe.from[i]], wireframe.vert[wireframe.to[i]], this.theCamera, outlineColor);
            }
            theCurve.setSmoothingMethod(smBefore);
        }
    }

    protected void drawArrow(Color arrowColor) {
        if (!this.showMesh) {
            return;
        }
        double arrowLen = 0.1;
        Object3D theObject = this.getController().getObject().getObject();
        if (theObject instanceof Curve) {
            Curve theCurve = (Curve)theObject;
            MeshVertex[] mv = theCurve.getVertices();
            Vec3 lastDir = new Vec3(mv[mv.length - 1].r);
            lastDir.subtract(mv[mv.length - 2].r);
            Vec3 b = MathHelper.randomOrtho(lastDir);
            lastDir.normalize();
            b.normalize();
            CoordinateSystem traffo = new CoordinateSystem(mv[mv.length - 1].r, b, lastDir);
            Mat4 traffoMat = traffo.fromLocal();
            Vec3[] arrow = new Vec3[]{MathHelper.toLen(new Vec3(0.0, -1.0, 1.0), arrowLen), MathHelper.toLen(new Vec3(0.0, -1.0, -1.0), arrowLen), MathHelper.toLen(new Vec3(-1.0, -1.0, 0.0), arrowLen), MathHelper.toLen(new Vec3(1.0, -1.0, 0.0), arrowLen)};
            int[] from = new int[arrow.length];
            int[] to = new int[arrow.length];
            Vec3[] arrowTrans = new Vec3[arrow.length + 1];
            arrowTrans[0] = traffo.getOrigin();
            for (int i = 0; i < arrow.length; ++i) {
                arrowTrans[i + 1] = traffoMat.times(arrow[i]);
                from[i] = 0;
                to[i] = i + 1;
            }
            this.renderWireframe(new WireframeMesh(arrowTrans, from, to), this.theCamera, arrowColor);
        }
    }

    protected void mousePressed(WidgetMouseEvent e) {
        super.mousePressed(e);
        this.mouseMoved = false;
    }

    protected void mouseDragged(WidgetMouseEvent e) {
        super.mouseDragged(e);
        this.mouseMoved = true;
    }

    protected void mouseReleased(WidgetMouseEvent e) {
        super.mouseReleased(e);
        if (!this.mouseMoved && e.getButton() == 3) {
            Object src = e.getSource();
            while (!(src instanceof AdvCurveEditorWindow) && src instanceof Widget) {
                src = ((Widget)src).getParent();
            }
            if (src instanceof AdvCurveEditorWindow) {
                ((AdvCurveEditorWindow)((Object)src)).showContextMenu(e);
            }
        }
    }
}

