/*
 * Decompiled with CFR 0.152.
 */
package troy.advcurves;

import artofillusion.CurveEditorWindow;
import artofillusion.LayoutWindow;
import artofillusion.ViewerCanvas;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingWindow;
import java.util.Collection;
import troy.advcurves.AdvCurve;
import troy.advcurves.Snapper;

public class MenuHandler {
    private EditingWindow theWindow = null;

    public MenuHandler(EditingWindow w) {
        this.theWindow = w;
    }

    public void doConvert() {
        if (!(this.theWindow instanceof LayoutWindow)) {
            return;
        }
        Collection selection = ((LayoutWindow)this.theWindow).getSelectedObjects();
        for (ObjectInfo oi : selection) {
            Object3D obj = oi.getObject();
            if (!(obj instanceof Curve)) continue;
            Curve orig = (Curve)obj;
            Vec3[] vecs = new Vec3[orig.getVertices().length];
            for (int i = 0; i < vecs.length; ++i) {
                vecs[i] = orig.getVertices()[i].r;
            }
            String addition = "";
            Curve out = null;
            if (obj instanceof AdvCurve) {
                out = new Curve(vecs, orig.getSmoothness(), orig.getSmoothingMethod(), orig.isClosed());
                addition = " (regular)";
            } else if (obj instanceof Curve) {
                out = new AdvCurve(vecs, orig.getSmoothness(), orig.getSmoothingMethod(), orig.isClosed());
                addition = " (advanced)";
            }
            if (out == null) continue;
            ((LayoutWindow)this.theWindow).addObject((Object3D)out, oi.getCoords().duplicate(), oi.getName() + addition, null);
        }
        this.theWindow.updateImage();
    }

    public void doAlignOnGrid() {
        if (!(this.theWindow instanceof CurveEditorWindow)) {
            return;
        }
        ObjectInfo oi = ((CurveEditorWindow)this.theWindow).getObject();
        MeshVertex[] v = ((Curve)oi.getObject()).getVertices();
        boolean[] selected = ((CurveEditorWindow)this.theWindow).getSelection();
        ViewerCanvas view = this.theWindow.getView();
        if (view == null) {
            return;
        }
        for (int i = 0; i < selected.length; ++i) {
            if (!selected[i]) continue;
            Snapper.snap(v[i].r, view);
        }
        this.theWindow.updateImage();
    }
}

