/*
 * Decompiled with CFR 0.152.
 */
package troy.advcurves;

import artofillusion.CurveEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.Scene;
import artofillusion.object.Curve;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BCheckBoxMenuItem;
import buoy.widget.BMenu;
import buoy.widget.BMenuItem;
import buoy.widget.BPopupMenu;
import buoy.widget.BSeparator;
import buoy.widget.MenuWidget;
import troy.advcurves.ExtendCurveTool;
import troy.advcurves.MenuHandler;

public class AdvCurveEditorWindow
extends CurveEditorWindow {
    private boolean topology = false;

    public AdvCurveEditorWindow(EditingWindow parent, String title, ObjectInfo obj, Runnable onClose, boolean allowTopology) {
        super(parent, title, obj, onClose, allowTopology);
        ToolPalette tools;
        this.topology = allowTopology;
        Scene sc = parent.getScene();
        for (int i = 0; i < this.theView.length; ++i) {
            MeshViewer view = (MeshViewer)this.theView[i];
            view.setScene(sc, obj);
            view.setGrid(sc.getGridSpacing(), sc.getGridSubdivisions(), sc.getShowGrid(), sc.getSnapToGrid());
        }
        if (this.topology && (tools = this.getToolPalette()) != null) {
            tools.addTool((EditingTool)new ExtendCurveTool((EditingWindow)this, (MeshEditController)this));
        }
        BMenuItem menuItem = Translate.menuItem((String)"advcurves:alignVerticesToGrid", (Object)new MenuHandler((EditingWindow)this), (String)"doAlignOnGrid");
        int position = 0;
        boolean added = false;
        for (position = this.meshMenu.getChildCount() - 1; !added && position >= 0; --position) {
            MenuWidget mw = this.meshMenu.getChild(position);
            if (!(mw instanceof BSeparator)) continue;
            this.meshMenu.add((MenuWidget)menuItem, position);
        }
    }

    protected void showContextMenu(WidgetMouseEvent e) {
        BPopupMenu popper = this.createPopupMenu();
        if (popper == null) {
            return;
        }
        popper.show(e.getWidget(), e.getX(), e.getY());
    }

    protected BPopupMenu createPopupMenu() {
        Curve obj = null;
        Object3D obj3d = this.getObject().getObject();
        if (!(obj3d instanceof Curve)) {
            return null;
        }
        obj = (Curve)obj3d;
        BPopupMenu popper = new BPopupMenu();
        if (this.topology) {
            popper.add((MenuWidget)Translate.menuItem((String)"deletePoints", (Object)((Object)this), (String)"deleteCommand"));
            popper.add((MenuWidget)Translate.menuItem((String)"subdivide", (Object)((Object)this), (String)"subdivideCommand"));
        }
        popper.add((MenuWidget)Translate.menuItem((String)"editPoints", (Object)((Object)this), (String)"setPointsCommand"));
        popper.add((MenuWidget)Translate.menuItem((String)"transformPoints", (Object)((Object)this), (String)"transformPointsCommand"));
        popper.add((MenuWidget)Translate.menuItem((String)"randomize", (Object)((Object)this), (String)"randomizeCommand"));
        popper.add((MenuWidget)Translate.menuItem((String)"centerCurve", (Object)((Object)this), (String)"centerCommand"));
        popper.add((MenuWidget)Translate.menuItem((String)"advcurves:alignVerticesToGrid", (Object)new MenuHandler((EditingWindow)this), (String)"doAlignOnGrid"));
        popper.addSeparator();
        popper.add((MenuWidget)Translate.menuItem((String)"smoothness", (Object)((Object)this), (String)"setSmoothnessCommand"));
        BMenu smoothMenu = null;
        smoothMenu = Translate.menu((String)"smoothingMethod");
        popper.add((MenuWidget)smoothMenu);
        this.smoothItem = new BCheckBoxMenuItem[3];
        this.smoothItem[0] = Translate.checkboxMenuItem((String)"none", (Object)((Object)this), (String)"smoothingChanged", (obj.getSmoothingMethod() == 0 ? 1 : 0) != 0);
        smoothMenu.add((MenuWidget)this.smoothItem[0]);
        this.smoothItem[1] = Translate.checkboxMenuItem((String)"interpolating", (Object)((Object)this), (String)"smoothingChanged", (obj.getSmoothingMethod() == 2 ? 1 : 0) != 0);
        smoothMenu.add((MenuWidget)this.smoothItem[1]);
        this.smoothItem[2] = Translate.checkboxMenuItem((String)"approximating", (Object)((Object)this), (String)"smoothingChanged", (obj.getSmoothingMethod() == 3 ? 1 : 0) != 0);
        smoothMenu.add((MenuWidget)this.smoothItem[2]);
        BMenuItem closeAndOpen = null;
        closeAndOpen = Translate.menuItem((String)"closedEnds", (Object)((Object)this), (String)"toggleClosedCommand");
        popper.add((MenuWidget)closeAndOpen);
        if (obj.isClosed()) {
            closeAndOpen.setText(Translate.text((String)"menu.openEnds"));
        }
        return popper;
    }
}

