/*
 * Decompiled with CFR 0.152.
 */
package troy.advcurves;

import artofillusion.Camera;
import artofillusion.CurveEditorWindow;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.MeshVertex;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.MeshEditingTool;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import java.util.Vector;
import troy.advcurves.Snapper;

public class ExtendCurveTool
extends MeshEditingTool {
    public ExtendCurveTool(EditingWindow fr, MeshEditController controller) {
        super(fr, controller);
        this.initButton("advcurves:extendCurve");
    }

    public int whichClicks() {
        return 1;
    }

    public boolean allowSelectionChanges() {
        return true;
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text((String)"advcurves:extendCurveTool.helpText"));
    }

    public String getToolTipText() {
        return Translate.text((String)"advcurves:extendCurveTool.tipText");
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        Curve obj;
        boolean[] selected = this.controller.getSelection();
        Curve curve = obj = this.controller.getObject().getObject() instanceof Curve ? (Curve)this.controller.getObject().getObject() : null;
        if (obj != null) {
            int selCount = 0;
            Vector<Integer> which = new Vector<Integer>();
            for (int i = 0; i < selected.length; ++i) {
                if (!selected[i]) continue;
                ++selCount;
                which.add(i);
            }
            if (selCount == 1 && (selected[0] || selected[selected.length - 1])) {
                this.theWindow.setUndoRecord(new UndoRecord(this.theWindow, false, 0, new Object[]{obj, obj.duplicate()}));
                Camera cam = view.getCamera();
                double distance = cam.getWorldToView().timesZ(obj.getVertices()[((Integer)which.get((int)0)).intValue()].r);
                Vec3 newPoint = Snapper.snap(cam.convertScreenToWorld(e.getPoint(), distance), view);
                MeshVertex[] origV = obj.getVertices();
                float[] origF = obj.getSmoothness();
                Vec3[] v = new Vec3[origV.length + 1];
                float[] f = new float[origF.length + 1];
                boolean[] s = new boolean[v.length];
                if (selected[selected.length - 1]) {
                    for (int i = 0; i < origV.length; ++i) {
                        v[i] = origV[i].r;
                        f[i] = origF[i];
                        s[i] = false;
                    }
                    v[v.length - 1] = newPoint;
                    f[f.length - 1] = 1.0f;
                    s[s.length - 1] = true;
                } else {
                    for (int i = 0; i < origV.length; ++i) {
                        v[i + 1] = origV[i].r;
                        f[i + 1] = origF[i];
                        s[i + 1] = false;
                    }
                    v[0] = newPoint;
                    f[0] = 1.0f;
                    s[0] = true;
                }
                obj.setShape(v, f);
                ((CurveEditorWindow)this.controller).setSelection(s);
            } else if (!(selCount != 2 || selected[0] && selected[selected.length - 1] && selected.length != 2 || Math.abs((Integer)which.get(0) - (Integer)which.get(1)) != 1)) {
                this.theWindow.setUndoRecord(new UndoRecord(this.theWindow, false, 0, new Object[]{obj, obj.duplicate()}));
                Camera cam = view.getCamera();
                double distance0 = cam.getWorldToView().timesZ(obj.getVertices()[((Integer)which.get((int)0)).intValue()].r);
                double distance1 = cam.getWorldToView().timesZ(obj.getVertices()[((Integer)which.get((int)1)).intValue()].r);
                double distance = (distance0 + distance1) / 2.0;
                Vec3 newPoint = Snapper.snap(cam.convertScreenToWorld(e.getPoint(), distance), view);
                MeshVertex[] origV = obj.getVertices();
                float[] origF = obj.getSmoothness();
                Vec3[] v = new Vec3[origV.length + 1];
                float[] f = new float[origF.length + 1];
                boolean[] s = new boolean[v.length];
                int npos = 0;
                int i = 0;
                while (i < origV.length) {
                    v[npos] = origV[i].r;
                    f[npos] = origF[i];
                    s[npos] = false;
                    if (i == (Integer)which.get(0)) {
                        v[++npos] = newPoint;
                        f[npos] = 1.0f;
                        s[npos] = true;
                    }
                    ++i;
                    ++npos;
                }
                obj.setShape(v, f);
                ((CurveEditorWindow)this.controller).setSelection(s);
            }
        }
    }
}

