package troy.advcurves;

import artofillusion.*;
import artofillusion.object.*;
import artofillusion.math.*;
import artofillusion.ui.*;
import buoy.event.WidgetMouseEvent;

/**
 * The actual tool which creates an advanced curve.
 * @author TroY
 */
public class CreateAdvCurve extends EditingTool
{
	/** Let's count all created objects */
	private static int objectCounter = 1;
	
	/** Common constructor, set tool button icon */
	public CreateAdvCurve(EditingWindow parent)
	{
		super(parent);
		initButton("advcurves:createTool");
	}
	
	/** Return tool tip */
	@Override
	public String getToolTipText()
	{
		return Translate.text("advcurves:createAdvancedCurve.tipText");
	}
	
	/** What to do when the user activates the tool: Set the window's help text */
	@Override
	public void activate()
	{
		super.activate();
		theWindow.setHelpText(Translate.text("advcurves:createAdvancedCurve.helpText"));
	}
	
	/** Tell AoI which clicks we want to catch */
	@Override
	public int whichClicks()
	{
		return ALL_CLICKS;
	}
	
	/** A click in the scene, let's create a new AdvCurve there */
	@Override
	public void mousePressed(WidgetMouseEvent e, ViewerCanvas view)
	{
		Scene theScene = theWindow.getScene();
		Camera cam  = view.getCamera();
		
		Vec3 origin = Snapper.snap(cam.convertScreenToWorld(e.getPoint(),
										Camera.DEFAULT_DISTANCE_TO_SCREEN), view);

		ObjectInfo toAdd = new ObjectInfo(new AdvCurve(), 
								new CoordinateSystem(origin, new Vec3(0.0, 0.0, 1.0),
								new Vec3(0.0, 1.0, 0.0)),
								"AdvCurve " + CreateAdvCurve.objectCounter);
		
		/*
		((LayoutWindow) theWindow).addObject(toAdd, null);
		((LayoutWindow) theWindow).setSelection(theWindow.getScene().getNumObjects()-1);
		((LayoutWindow) theWindow).setModified();
		((LayoutWindow) theWindow).updateImage();
		((LayoutWindow) theWindow).rebuildItemList();
		*/
		UndoRecord undo = new UndoRecord(theWindow, false);
		undo.addCommandAtBeginning(UndoRecord.SET_SCENE_SELECTION, new Object [] {((LayoutWindow) theWindow).getSelectedIndices()});
		((LayoutWindow) theWindow).addObject(toAdd, undo);
		theWindow.setUndoRecord(undo);
		((LayoutWindow) theWindow).setSelection(theScene.getNumObjects()-1);
		theWindow.updateImage();
		CreateAdvCurve.objectCounter++;
	}
}
