package troy.advcurves;

import artofillusion.*;
import artofillusion.ui.*;
import artofillusion.object.*;
import artofillusion.math.*;

import java.util.*;

/**
 * This will handle all menu commands - as long as they're few, no methods
 * will be "outsourced" ;>
 * @author TroY
 */
public class MenuHandler
{
	/** Reference to parent window */
	private EditingWindow theWindow = null;
	
	/** Common constructor */
	public MenuHandler(EditingWindow w)
	{
		theWindow = w;
	}
	
	// --------------------------------------------------------------------
	// -- Main Window --
	/** Try to convert all selected objects */
	public void doConvert()
	{
		if (!(theWindow instanceof LayoutWindow))
			return;
		
		Collection<ObjectInfo> selection = ((LayoutWindow)theWindow).getSelectedObjects();
		for (ObjectInfo oi : selection)
		{
			Object3D obj = oi.getObject();

			// If this is a curve ...
			if (obj instanceof Curve)
			{
				// ... get vertices and everything
				Curve orig = (Curve)obj;
				
				Vec3[] vecs = new Vec3[orig.getVertices().length];
				for (int i = 0; i < vecs.length; i++)
				{
					vecs[i] = orig.getVertices()[i].r;
				}
				
				
				String addition = "";
				Object3D out = null;
				// now, if it's even an advanced curve, convert it down
				if (obj instanceof AdvCurve)
				{
					out = new Curve(vecs, orig.getSmoothness(),
										orig.getSmoothingMethod(), orig.isClosed());
					addition = " (regular)";
				}
				// just to have it consequent ;=) and maybe there will be some other types later
				else if (obj instanceof Curve)
				{
					out = new AdvCurve(vecs, orig.getSmoothness(),
										orig.getSmoothingMethod(), orig.isClosed());
					addition = " (advanced)";
				}
				

				if (out != null)
				{
					((LayoutWindow)theWindow).addObject(out, oi.getCoords().duplicate(), oi.getName() + addition, null);
				}
			}
		}
		theWindow.updateImage();
	}
	
	// --------------------------------------------------------------------
	// -- Editing Window --
	/** Align selected vertices on grid */
	public void doAlignOnGrid()
	{
		if (!(theWindow instanceof CurveEditorWindow))
			return;
			
		ObjectInfo   oi         = ((CurveEditorWindow)theWindow).getObject();
		MeshVertex[] v          = ((Curve)oi.getObject()).getVertices();
		boolean      selected[] = ((CurveEditorWindow)theWindow).getSelection();
		ViewerCanvas view       = theWindow.getView();
		
		if (view == null)
			return;

		for (int i = 0; i < selected.length; i++)
		{
			if (selected[i])
			{
				Snapper.snap(v[i].r, view);
			}
		}
		
		theWindow.updateImage();
	}
}
