package troy.advcurves;

import artofillusion.*;
import artofillusion.object.*;
import artofillusion.texture.*;
import artofillusion.animation.*;
import artofillusion.math.*;
import artofillusion.ui.*;
import java.io.*;
import java.awt.*;
import buoy.event.*;
import buoy.widget.*;

/**
 * Object type: Advanced Curves
 * @author TroY
 */
public class AdvCurve extends Curve
{
	// Constructors
	/**
	 * Default Constructor - create a 2-vertex curve
	 */
	public AdvCurve()
	{
		this(new Vec3[] {new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 1.0, 0.0)},
			 new float[] {1.0f, 1.0f}, Mesh.APPROXIMATING, false);
	}
	
	/**
	 * Create the curve according to these parameters - passed on to super class
	 */
	public AdvCurve(Vec3 v[], float smoothness[], int smoothingMethod, boolean isClosed)
	{
		super(v, smoothness, smoothingMethod, isClosed);
	}	
	
	/**
	 * Read from a file - passed on to super class
	 */
	public AdvCurve(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException
	{
		super(in, theScene);
	}

	// Editing Windows
	/**
	 * Create/show a new AdvCurveEditorWindow for this curve
	 */
	@Override
	public void edit(EditingWindow parent, ObjectInfo info, Runnable cb)
	{		
		AdvCurveEditorWindow ed = new AdvCurveEditorWindow(parent, "AdvancedCurve object '"+ info.getName() +"'", info, cb, true);
		ed.setVisible(true);
	}
	
	/**
	 * Create/show a new AdvCurveEditorWindow for this curve-actor
	 */
	@Override
	public void editGesture(final EditingWindow parent, ObjectInfo info, Runnable cb, ObjectInfo realObject)
	{
		AdvCurveEditorWindow ed = new AdvCurveEditorWindow(parent, "(AdvancedCurve) Gesture '"+ info.getName() +"'", info, cb, false);
		ViewerCanvas views[] = ed.getAllViews();
		for (int i = 0; i < views.length; i++)
			((MeshViewer) views[i]).setScene(parent.getScene(), realObject);
		ed.setVisible(true);
	}

	// Mesh Viewer
	/**
	 * Define which objects draws the curve
	 * @return an instance of AdvCurveViewer which can draw outlines etc
	 */
	@Override
	public MeshViewer createMeshViewer(MeshEditController controller, RowContainer options)
	{
		return new AdvCurveViewer(controller, options);
	}
	
	// Copy and Paste
	/**
	 * Duplicate this object.
	 * @return a copy of this object, instance of AdvCurve
	 */
	@Override
	public Object3D duplicate()
	{
		Vec3 v[] = new Vec3 [vertex.length];
		float s[] = new float [vertex.length];

		for (int i = 0; i < vertex.length; i++)
		{
			v[i] = new Vec3(vertex[i].r);
			s[i] = smoothness[i];
		}
		return new AdvCurve(v, s, smoothingMethod, closed);
	}
	
	/**
	 * Copy properties from another AdvCurve
	 * @param obj must be an instance of AdvCurve
	 */
	@Override
	public void copyObject(Object3D obj)
	{
		AdvCurve cv = (AdvCurve) obj;
		MeshVertex v[] = cv.getVertices();

		vertex = new MeshVertex [v.length];
		smoothness = new float [v.length];
		for (int i = 0; i < vertex.length; i++)
		{
			vertex[i] = new MeshVertex(new Vec3(v[i].r));
			smoothness[i] = cv.smoothness[i];
		}
		
		smoothingMethod = cv.smoothingMethod;
		setClosed(cv.closed);
		clearCachedMesh();
	}
}
