package troy.advcurves;

import artofillusion.*;
import artofillusion.object.*;
import artofillusion.texture.*;
import artofillusion.animation.*;
import artofillusion.math.*;
import artofillusion.ui.*;
import buoy.event.*;
import buoy.widget.*;
import java.awt.*;

/**
 * This class alters the existing CurveEditorWindow
 * @author TroY
 */
public class AdvCurveEditorWindow extends CurveEditorWindow
{
	/** Are we able to add/remove vertices? */
	private boolean topology = false;
	
	/** Constructor which adds new tools and sets grid settings */
	public AdvCurveEditorWindow(EditingWindow parent, String title,
					ObjectInfo obj, Runnable onClose, boolean allowTopology)
	{
		super(parent, title, obj, onClose, allowTopology);

		this.topology = allowTopology;

		// *** Grid settings
		Scene sc = parent.getScene();
		for (int i = 0; i < theView.length; i++)
		{
			MeshViewer view = (MeshViewer) theView[i];
			view.setScene(sc, obj);
			view.setGrid(sc.getGridSpacing(), sc.getGridSubdivisions(),
							sc.getShowGrid(), sc.getSnapToGrid());
		}
		
		// *** Add the new tool
		if (topology)
		{
			ToolPalette tools = getToolPalette();
			if (tools != null)
			{
				tools.addTool(new ExtendCurveTool(this, this));
			}
		}
		
		// *** Modify menu
		BMenuItem menuItem = Translate.menuItem("advcurves:alignVerticesToGrid", new MenuHandler(this), "doAlignOnGrid");
		
		// add it before the first separator -> under "Center Curve"
		int position = 0;
		boolean added = false;
		for (position = meshMenu.getChildCount() - 1; !added && position >= 0; position--)
		{
			MenuWidget mw = meshMenu.getChild(position);
			if (mw instanceof BSeparator)
			{
				meshMenu.add(menuItem, position);
			}
		}
	}

	/** Show right mouse context menu */
	protected void showContextMenu(WidgetMouseEvent e)
	{
		// Copy the common "Curve" menu to a popup menu
		BPopupMenu popper = createPopupMenu();
		
		if (popper == null)
			return;
		
		popper.show(e.getWidget(), e.getX(), e.getY());
	}
	
	/** Create right mouse context menu */
	protected BPopupMenu createPopupMenu()
	{
		// Sadly, I'm not able to duplicate a whole BMenu. So we have to
		// create a very own one...
		
		Curve obj = null;
		Object3D obj3d = getObject().getObject();
		if (obj3d instanceof Curve)
		{
			obj = (Curve)obj3d;
		}
		else
		{
			return null;
		}
		
		BPopupMenu popper = new BPopupMenu();
		
		if (topology)
		{
			popper.add(Translate.menuItem("deletePoints", this, "deleteCommand"));
			popper.add(Translate.menuItem("subdivide", this, "subdivideCommand"));
		}
		
		popper.add(Translate.menuItem("editPoints", this, "setPointsCommand"));
		popper.add(Translate.menuItem("transformPoints", this, "transformPointsCommand"));
		popper.add(Translate.menuItem("randomize", this, "randomizeCommand"));
		popper.add(Translate.menuItem("centerCurve", this, "centerCommand"));
		popper.add(Translate.menuItem("advcurves:alignVerticesToGrid", new MenuHandler(this), "doAlignOnGrid"));
		popper.addSeparator();
		popper.add(Translate.menuItem("smoothness", this, "setSmoothnessCommand"));
		
		BMenu smoothMenu = null;
		popper.add(smoothMenu = Translate.menu("smoothingMethod"));
		smoothItem = new BCheckBoxMenuItem [3];
		smoothMenu.add(smoothItem[0] = Translate.checkboxMenuItem("none", this, "smoothingChanged", obj.getSmoothingMethod() == Curve.NO_SMOOTHING));
		smoothMenu.add(smoothItem[1] = Translate.checkboxMenuItem("interpolating", this, "smoothingChanged", obj.getSmoothingMethod() == Curve.INTERPOLATING));
		smoothMenu.add(smoothItem[2] = Translate.checkboxMenuItem("approximating", this, "smoothingChanged", obj.getSmoothingMethod() == Curve.APPROXIMATING));
		
		BMenuItem closeAndOpen = null;
		popper.add(closeAndOpen = Translate.menuItem("closedEnds", this, "toggleClosedCommand"));
		if (obj.isClosed())
			closeAndOpen.setText(Translate.text("menu.openEnds"));
		
		return popper;
	}
}
