/*
	Implements "Plugin"
	
	TroY, April 2008
 */


package troy.advcurves;

import artofillusion.*;
import artofillusion.ui.*;
import buoy.widget.*;

/**
 * Manages palette and menus
 * @author TroY
 */
public class AdvCurvesPlugin implements Plugin
{
	/**
     * Process messages sent to plugin by AoI (see AoI API description)
     *
     * @param  message  The message
     * @param  args     Arguments depending on the message
     */
    public void processMessage(int message, Object args[])
    {
    	if (message == Plugin.SCENE_WINDOW_CREATED)
    	{
    		// **************************************************************
    		// add a palette tool item at the end
            LayoutWindow layout = (LayoutWindow)args[0];
            ToolPalette palette = layout.getToolPalette();
            palette.addTool(palette.getNumTools(), new CreateAdvCurve(layout));
            palette.toggleDefaultTool();
            palette.toggleDefaultTool();
            
            // **************************************************************
            // add menu items to "Object"
            BMenuItem menuItem = Translate.menuItem("advcurves:curveConversion", new MenuHandler(layout), "doConvert");
            BMenuBar menuBar = layout.getMenuBar();
            BMenu toolsMenu = menuBar.getChild(2);
            
            // add it before the first separator -> under "Convert to Actor..."
            int position = 0;
            boolean added = false;
            for (position = toolsMenu.getChildCount() - 1; !added && position >= 0; position--)
            {
            	MenuWidget mw = toolsMenu.getChild(position);
            	if (mw instanceof BSeparator)
            	{
            		toolsMenu.add(menuItem, position);
            	}
            }

            layout.layoutChildren();
    	}
    }
}
